/*
 * Decompiled with CFR 0.152.
 */
package replicatorg.machine.model;

import java.util.concurrent.atomic.AtomicReference;
import org.w3c.dom.Node;
import replicatorg.app.Base;
import replicatorg.app.tools.XML;

public class ToolModel {
    public static int MOTOR_CLOCKWISE = 1;
    public static int MOTOR_COUNTER_CLOCKWISE = 2;
    protected int toolStatus;
    protected Node xml;
    protected String name;
    protected String type;
    protected String material;
    protected int index;
    protected boolean motorEnabled;
    protected int motorDirection;
    protected double motorSpeedRPM;
    protected int motorSpeedPWM;
    protected double motorSpeedReadingRPM;
    protected int motorSpeedReadingPWM;
    protected boolean motorUsesRelay = false;
    protected boolean motorHasEncoder;
    protected int motorEncoderPPR;
    protected boolean motorIsStepper;
    protected double motorSteps;
    protected String motorStepperAxis;
    protected boolean spindleEnabled;
    protected int spindleDirection;
    protected double spindleSpeedRPM;
    protected int spindleSpeedPWM;
    protected double spindleSpeedReadingRPM;
    protected int spindleSpeedReadingPWM;
    protected boolean spindleHasEncoder;
    protected int spindleEncoderPPR;
    protected final AtomicReference<Double> currentTemperature = new AtomicReference<Double>(0.0);
    protected double targetTemperature;
    protected AtomicReference<Double> platformCurrentTemperature = new AtomicReference<Double>(0.0);
    protected double platformTargetTemperature;
    protected boolean floodCoolantEnabled;
    protected boolean mistCoolantEnabled;
    protected boolean fanEnabled;
    protected boolean valveOpen;
    protected boolean colletOpen;
    protected boolean hasMotor = false;
    protected boolean hasSpindle = false;
    protected boolean hasHeater = false;
    protected boolean hasHeatedPlatform = false;
    protected boolean hasAutomatedPlatform = false;
    protected boolean hasFloodCoolant = false;
    protected boolean hasMistCoolant = false;
    protected boolean hasFan = false;
    protected boolean hasValve = false;
    protected boolean hasCollet = false;

    public ToolModel() {
        this._initialize();
    }

    public ToolModel(Node n) {
        this._initialize();
        this.loadXML(n);
    }

    private void _initialize() {
        this.name = "Generic Tool";
        this.type = "tool";
        this.material = "unknown";
        this.index = 0;
        this.setMotorDirection(MOTOR_CLOCKWISE);
        this.disableMotor();
        this.setSpindleDirection(MOTOR_CLOCKWISE);
        this.disableMotor();
        this.disableFloodCoolant();
        this.disableMistCoolant();
        this.disableFan();
        this.closeValve();
        this.closeCollet();
    }

    private boolean isTrueOrOne(String s) {
        if (s == null) {
            return false;
        }
        if (Boolean.parseBoolean(s)) {
            return true;
        }
        try {
            if (Integer.parseInt(s) == 1) {
                return true;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return false;
    }

    public void loadXML(Node node) {
        this.xml = node;
        String n = XML.getAttributeValue(this.xml, "name");
        if (n != null) {
            this.name = n;
        }
        if ((n = XML.getAttributeValue(this.xml, "index")) != null) {
            this.index = Integer.parseInt(n);
        }
        if ((n = XML.getAttributeValue(this.xml, "type")) != null) {
            this.type = n;
        }
        if ((n = XML.getAttributeValue(this.xml, "material")) != null) {
            this.material = n;
        }
        if (this.isTrueOrOne(n = XML.getAttributeValue(this.xml, "motor"))) {
            this.hasMotor = true;
            n = XML.getAttributeValue(this.xml, "motor_encoder_ppr");
            try {
                if (n != null && Integer.parseInt(n) > 0) {
                    this.motorHasEncoder = true;
                    this.motorEncoderPPR = Integer.parseInt(n);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            n = XML.getAttributeValue(this.xml, "motor_steps");
            try {
                if (n != null && Double.parseDouble(n) > 0.0) {
                    this.motorIsStepper = true;
                    this.motorSteps = Double.parseDouble(n);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            n = XML.getAttributeValue(this.xml, "stepper_axis");
            try {
                if (n != null && n.length() > 0) {
                    this.motorStepperAxis = n;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            n = XML.getAttributeValue(this.xml, "default_rpm");
            try {
                if (n != null && Double.parseDouble(n) > 0.0) {
                    this.motorSpeedRPM = Double.parseDouble(n);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            n = XML.getAttributeValue(this.xml, "default_pwm");
            try {
                if (n != null && Integer.parseInt(n) > 0) {
                    this.motorSpeedPWM = Integer.parseInt(n);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            n = XML.getAttributeValue(this.xml, "uses_relay");
            try {
                if (n != null) {
                    this.motorUsesRelay = this.isTrueOrOne(n);
                    if (this.motorUsesRelay) {
                        Base.logger.severe("Notice: Motor controller configured to use relay, PWM values will be overridden");
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.isTrueOrOne(n = XML.getAttributeValue(this.xml, "spindle"))) {
            this.hasSpindle = true;
            n = XML.getAttributeValue(this.xml, "motor_encoder_ppr");
            try {
                if (n != null && Integer.parseInt(n) > 0) {
                    this.motorHasEncoder = true;
                    this.motorEncoderPPR = Integer.parseInt(n);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        n = XML.getAttributeValue(this.xml, "floodcoolant");
        this.hasFloodCoolant = this.hasFloodCoolant || this.isTrueOrOne(n);
        n = XML.getAttributeValue(this.xml, "mistcoolant");
        this.hasMistCoolant = this.hasMistCoolant || this.isTrueOrOne(n);
        n = XML.getAttributeValue(this.xml, "fan");
        this.hasFan = this.hasFan || this.isTrueOrOne(n);
        n = XML.getAttributeValue(this.xml, "valve");
        this.hasValve = this.hasValve || this.isTrueOrOne(n);
        n = XML.getAttributeValue(this.xml, "collet");
        this.hasCollet = this.hasCollet || this.isTrueOrOne(n);
        n = XML.getAttributeValue(this.xml, "heater");
        this.hasHeater = this.hasHeater || this.isTrueOrOne(n);
        n = XML.getAttributeValue(this.xml, "heatedplatform");
        this.hasHeatedPlatform = this.hasHeatedPlatform || this.isTrueOrOne(n);
        n = XML.getAttributeValue(this.xml, "automatedplatform");
        this.hasAutomatedPlatform = this.hasAutomatedPlatform || this.isTrueOrOne(n);
        String result = "Loading " + this.type + " '" + this.name + "': ";
        result = String.valueOf(result) + "material: " + this.material + ", ";
        result = String.valueOf(result) + "with these capabilities: ";
        if (this.hasFloodCoolant) {
            result = String.valueOf(result) + "flood coolant, ";
        }
        if (this.hasMotor) {
            result = String.valueOf(result) + "motor, ";
        }
        if (this.hasSpindle) {
            result = String.valueOf(result) + "spindle, ";
        }
        if (this.hasMistCoolant) {
            result = String.valueOf(result) + "mist coolant, ";
        }
        if (this.hasFan) {
            result = String.valueOf(result) + "fan, ";
        }
        if (this.hasValve) {
            result = String.valueOf(result) + "valve, ";
        }
        if (this.hasCollet) {
            result = String.valueOf(result) + "collet, ";
        }
        if (this.hasHeater) {
            result = String.valueOf(result) + "heater, ";
        }
        if (this.hasHeatedPlatform) {
            result = String.valueOf(result) + "hasHeatedPlatform, ";
        }
        if (this.hasAutomatedPlatform) {
            result = String.valueOf(result) + "hasAutomatedPlatform, ";
        }
        if (this.motorIsStepper) {
            result = String.valueOf(result) + "motorIsStepper, ";
            result = String.valueOf(result) + "motorStepperAxis: " + this.motorStepperAxis + ", ";
            result = String.valueOf(result) + "motorSteps: " + this.motorSteps + ", ";
        }
    }

    public String getName() {
        return this.name;
    }

    public void setIndex(int i) {
        this.index = i;
    }

    public int getIndex() {
        return this.index;
    }

    public String getType() {
        return this.type;
    }

    public int getToolStatus() {
        return this.toolStatus;
    }

    public void setToolStatus(int status) {
        this.toolStatus = status;
    }

    public void setMotorDirection(int dir) {
        this.motorDirection = dir;
    }

    public int getMotorDirection() {
        return this.motorDirection;
    }

    public void setMotorSpeedRPM(double rpm) {
        this.motorSpeedRPM = rpm;
    }

    public void setMotorSpeedPWM(int pwm) {
        this.motorSpeedPWM = pwm;
    }

    public double getMotorSpeedRPM() {
        return this.motorSpeedRPM;
    }

    public double getMotorSteps() {
        return this.motorSteps;
    }

    public int getMotorSpeedPWM() {
        return this.motorSpeedPWM;
    }

    public boolean getMotorUsesRelay() {
        return this.motorUsesRelay;
    }

    public void setMotorSpeedReadingRPM(double rpm) {
        this.motorSpeedReadingRPM = rpm;
    }

    public void setMotorSpeedReadingPWM(int pwm) {
        this.motorSpeedReadingPWM = pwm;
    }

    public double getMotorSpeedReadingRPM() {
        return this.motorSpeedReadingRPM;
    }

    public int getMotorSpeedReadingPWM() {
        return this.motorSpeedReadingPWM;
    }

    public void enableMotor() {
        this.motorEnabled = true;
    }

    public void disableMotor() {
        this.motorEnabled = false;
    }

    public boolean isMotorEnabled() {
        return this.motorEnabled;
    }

    public boolean hasMotor() {
        return this.hasMotor;
    }

    public boolean motorHasEncoder() {
        return this.motorHasEncoder;
    }

    public boolean motorIsStepper() {
        return this.motorIsStepper;
    }

    public String getMotorStepperAxis() {
        return this.motorStepperAxis;
    }

    public void setSpindleDirection(int dir) {
        this.spindleDirection = dir;
    }

    public int getSpindleDirection() {
        return this.spindleDirection;
    }

    public void setSpindleSpeedRPM(double rpm) {
        this.spindleSpeedRPM = rpm;
    }

    public void setSpindleSpeedPWM(int pwm) {
        this.spindleSpeedPWM = pwm;
    }

    public double getSpindleSpeedRPM() {
        return this.spindleSpeedRPM;
    }

    public int getSpindleSpeedPWM() {
        return this.spindleSpeedPWM;
    }

    public void setSpindleSpeedReadingRPM(double rpm) {
        this.spindleSpeedReadingRPM = rpm;
    }

    public void setSpindleSpeedReadingPWM(int pwm) {
        this.spindleSpeedReadingPWM = pwm;
    }

    public double getSpindleSpeedReadingRPM() {
        return this.spindleSpeedReadingRPM;
    }

    public int getSpindleSpeedReadingPWM() {
        return this.spindleSpeedReadingPWM;
    }

    public void enableSpindle() {
        this.spindleEnabled = true;
    }

    public void disableSpindle() {
        this.spindleEnabled = false;
    }

    public boolean isSpindleEnabled() {
        return this.spindleEnabled;
    }

    public boolean hasSpindle() {
        return this.hasSpindle;
    }

    public boolean spindleHasEncoder() {
        return this.spindleHasEncoder;
    }

    public void setTargetTemperature(double temperature) {
        this.targetTemperature = temperature;
    }

    public double getTargetTemperature() {
        return this.targetTemperature;
    }

    public void setCurrentTemperature(double temperature) {
        this.currentTemperature.set(temperature);
    }

    public double getCurrentTemperature() {
        return this.currentTemperature.get();
    }

    public boolean hasHeater() {
        return this.hasHeater;
    }

    public void setPlatformTargetTemperature(double temperature) {
        this.platformTargetTemperature = temperature;
    }

    public double getPlatformTargetTemperature() {
        return this.platformTargetTemperature;
    }

    public void setPlatformCurrentTemperature(double temperature) {
        this.platformCurrentTemperature.set(temperature);
    }

    public double getPlatformCurrentTemperature() {
        return this.platformCurrentTemperature.get();
    }

    public boolean hasHeatedPlatform() {
        return this.hasHeatedPlatform;
    }

    public boolean hasAutomatedPlatform() {
        return this.hasAutomatedPlatform;
    }

    public void enableFloodCoolant() {
        this.floodCoolantEnabled = true;
    }

    public void disableFloodCoolant() {
        this.floodCoolantEnabled = false;
    }

    public boolean isFloodCoolantEnabled() {
        return this.floodCoolantEnabled;
    }

    public boolean hasFloodCoolant() {
        return this.hasFloodCoolant;
    }

    public void enableMistCoolant() {
        this.mistCoolantEnabled = true;
    }

    public void disableMistCoolant() {
        this.mistCoolantEnabled = false;
    }

    public boolean isMistCoolantEnabled() {
        return this.mistCoolantEnabled;
    }

    public boolean hasMistCoolant() {
        return this.hasMistCoolant;
    }

    public void enableFan() {
        this.fanEnabled = true;
    }

    public void disableFan() {
        this.fanEnabled = false;
    }

    public boolean isFanEnabled() {
        return this.fanEnabled;
    }

    public boolean hasFan() {
        return this.hasFan;
    }

    public void openValve() {
        this.valveOpen = true;
    }

    public void closeValve() {
        this.valveOpen = false;
    }

    public boolean isValveOpen() {
        return this.valveOpen;
    }

    public boolean hasValve() {
        return this.hasValve;
    }

    public void openCollet() {
        this.colletOpen = true;
    }

    public void closeCollet() {
        this.colletOpen = false;
    }

    public boolean isColletOpen() {
        return this.colletOpen;
    }

    public boolean hasCollet() {
        return this.hasCollet;
    }

    public Node getXml() {
        return this.xml;
    }
}

